/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile.corporea;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import vazkii.botania.api.corporea.ICorporeaInterceptor;
import vazkii.botania.api.corporea.ICorporeaNode;
import vazkii.botania.api.corporea.ICorporeaRequestMatcher;
import vazkii.botania.api.corporea.ICorporeaSpark;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.corporea.TileCorporeaBase;
import vazkii.botania.common.block.tile.corporea.TileCorporeaRetainer;

public class TileCorporeaInterceptor
extends TileCorporeaBase
implements ICorporeaInterceptor {
    public TileCorporeaInterceptor(BlockPos pos, BlockState state) {
        super(ModTiles.CORPOREA_INTERCEPTOR, pos, state);
    }

    @Override
    public void interceptRequest(ICorporeaRequestMatcher request, int count, ICorporeaSpark spark, ICorporeaSpark source, List<ItemStack> stacks, List<ICorporeaNode> nodes, boolean doit) {
    }

    @Override
    public void interceptRequestLast(ICorporeaRequestMatcher request, int count, ICorporeaSpark spark, ICorporeaSpark source, List<ItemStack> stacks, List<ICorporeaNode> nodes, boolean doit) {
        List<ItemStack> filter = this.getFilter();
        boolean filterMatch = false;
        for (ItemStack itemStack : filter) {
            if (!request.test(itemStack)) continue;
            filterMatch = true;
        }
        if (filterMatch || filter.isEmpty()) {
            int missing = count;
            for (ItemStack stack : stacks) {
                missing -= stack.m_41613_();
            }
            if (missing > 0 && !((Boolean)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61448_)).booleanValue()) {
                BlockPos blockPos = source.getSparkNode().getPos();
                ArrayList<TileCorporeaRetainer> retainers = new ArrayList<TileCorporeaRetainer>();
                for (Direction dir : Direction.values()) {
                    BlockEntity tile = this.f_58857_.m_7702_(this.f_58858_.m_142300_(dir));
                    if (!(tile instanceof TileCorporeaRetainer)) continue;
                    TileCorporeaRetainer retainer = (TileCorporeaRetainer)tile;
                    retainers.add(retainer);
                    retainer.forget();
                }
                this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(true)));
                this.f_58857_.m_186460_(this.m_58899_(), this.m_58900_().m_60734_(), 2);
                for (TileCorporeaRetainer retainer : retainers) {
                    retainer.remember(blockPos, request, count, missing);
                }
            }
        }
    }

    private List<ItemStack> getFilter() {
        ArrayList<ItemStack> filter = new ArrayList<ItemStack>();
        for (Direction dir : Direction.values()) {
            List frames = this.f_58857_.m_45976_(ItemFrame.class, new AABB(this.f_58858_.m_142300_(dir), this.f_58858_.m_142300_(dir).m_142082_(1, 1, 1)));
            for (ItemFrame frame : frames) {
                ItemStack stack;
                Direction orientation = frame.m_6350_();
                if (orientation != dir || (stack = frame.m_31822_()).m_41619_()) continue;
                filter.add(stack);
            }
        }
        return filter;
    }
}

